/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentOperationHandler;
import com.badlogic.ashley.core.ComponentType;
import com.badlogic.ashley.signals.Signal;
import com.badlogic.ashley.utils.Bag;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Bits;

public class Entity {
    public int flags = 0;
    public final Signal<Entity> componentAdded;
    public final Signal<Entity> componentRemoved;
    boolean scheduledForRemoval;
    boolean removing;
    ComponentOperationHandler componentOperationHandler;
    private Bag<Component> components = new Bag();
    private Array<Component> componentsArray = new Array(false, 16);
    private ImmutableArray<Component> immutableComponentsArray = new ImmutableArray<Component>(this.componentsArray);
    private Bits componentBits = new Bits();
    private Bits familyBits = new Bits();

    public Entity() {
        this.componentAdded = new Signal();
        this.componentRemoved = new Signal();
    }

    public Entity add(Component component) {
        if (this.addInternal(component)) {
            if (this.componentOperationHandler != null) {
                this.componentOperationHandler.add(this);
            } else {
                this.notifyComponentAdded();
            }
        }
        return this;
    }

    public <T extends Component> T addAndReturn(T component) {
        this.add(component);
        return component;
    }

    public <T extends Component> T remove(Class<T> componentClass) {
        ComponentType componentType = ComponentType.getFor(componentClass);
        int componentTypeIndex = componentType.getIndex();
        if (this.components.isIndexWithinBounds(componentTypeIndex)) {
            Component removeComponent = this.components.get(componentTypeIndex);
            if (removeComponent != null && this.removeInternal(componentClass) != null) {
                if (this.componentOperationHandler != null) {
                    this.componentOperationHandler.remove(this);
                } else {
                    this.notifyComponentRemoved();
                }
            }
            return (T)removeComponent;
        }
        return null;
    }

    public void removeAll() {
        while (this.componentsArray.size > 0) {
            this.remove(this.componentsArray.get(0).getClass());
        }
    }

    public ImmutableArray<Component> getComponents() {
        return this.immutableComponentsArray;
    }

    public <T extends Component> T getComponent(Class<T> componentClass) {
        return this.getComponent(ComponentType.getFor(componentClass));
    }

    <T extends Component> T getComponent(ComponentType componentType) {
        int componentTypeIndex = componentType.getIndex();
        if (componentTypeIndex < this.components.getCapacity()) {
            return (T)this.components.get(componentType.getIndex());
        }
        return null;
    }

    boolean hasComponent(ComponentType componentType) {
        return this.componentBits.get(componentType.getIndex());
    }

    Bits getComponentBits() {
        return this.componentBits;
    }

    Bits getFamilyBits() {
        return this.familyBits;
    }

    boolean addInternal(Component component) {
        Class<?> componentClass = component.getClass();
        Object oldComponent = this.getComponent(componentClass);
        if (component == oldComponent) {
            return false;
        }
        if (oldComponent != null) {
            this.removeInternal(componentClass);
        }
        int componentTypeIndex = ComponentType.getIndexFor(componentClass);
        this.components.set(componentTypeIndex, component);
        this.componentsArray.add(component);
        this.componentBits.set(componentTypeIndex);
        return true;
    }

    Component removeInternal(Class<? extends Component> componentClass) {
        ComponentType componentType = ComponentType.getFor(componentClass);
        int componentTypeIndex = componentType.getIndex();
        Component removeComponent = this.components.get(componentTypeIndex);
        if (removeComponent != null) {
            this.components.set(componentTypeIndex, null);
            this.componentsArray.removeValue(removeComponent, true);
            this.componentBits.clear(componentTypeIndex);
            return removeComponent;
        }
        return null;
    }

    void notifyComponentAdded() {
        this.componentAdded.dispatch(this);
    }

    void notifyComponentRemoved() {
        this.componentRemoved.dispatch(this);
    }

    public boolean isScheduledForRemoval() {
        return this.scheduledForRemoval;
    }

    public boolean isRemoving() {
        return this.removing;
    }
}

