/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btPersistentManifold;

public class ContactCache
extends BulletBase {
    private long swigCPtr;

    protected ContactCache(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public ContactCache(long cPtr, boolean cMemoryOwn) {
        this("ContactCache", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(ContactCache obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_ContactCache(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        CollisionJNI.ContactCache_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        CollisionJNI.ContactCache_change_ownership(this, this.swigCPtr, true);
    }

    public ContactCache() {
        this(false);
        this.enable();
    }

    public void setCacheTime(float value) {
        CollisionJNI.ContactCache_cacheTime_set(this.swigCPtr, this, value);
    }

    public float getCacheTime() {
        return CollisionJNI.ContactCache_cacheTime_get(this.swigCPtr, this);
    }

    private ContactCache(boolean dummy) {
        this(CollisionJNI.new_ContactCache(dummy), true);
        CollisionJNI.ContactCache_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public void enable() {
        CollisionJNI.ContactCache_enable(this.swigCPtr, this);
    }

    public void disable() {
        CollisionJNI.ContactCache_disable(this.swigCPtr, this);
    }

    public boolean isEnabled() {
        return CollisionJNI.ContactCache_isEnabled(this.swigCPtr, this);
    }

    public void onContactStarted(btPersistentManifold manifold, boolean match0, boolean match1) {
        CollisionJNI.ContactCache_onContactStarted(this.swigCPtr, this, btPersistentManifold.getCPtr(manifold), manifold, match0, match1);
    }

    public void onContactEnded(btCollisionObject colObj0, boolean match0, btCollisionObject colObj1, boolean match1) {
        CollisionJNI.ContactCache_onContactEnded(this.swigCPtr, this, btCollisionObject.getCPtr(colObj0), colObj0, match0, btCollisionObject.getCPtr(colObj1), colObj1, match1);
    }

    public void clear() {
        CollisionJNI.ContactCache_clear(this.swigCPtr, this);
    }

    public void update(float delta) {
        CollisionJNI.ContactCache_update(this.swigCPtr, this, delta);
    }
}

