/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.GdxCollisionObjectBridge;
import com.badlogic.gdx.physics.bullet.collision.btBroadphaseProxy;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.LongMap;

public class btCollisionObject
extends BulletBase
implements Disposable {
    private long swigCPtr;
    public static final LongMap<btCollisionObject> instances = new LongMap();
    protected GdxCollisionObjectBridge gdxBridge;
    protected int userValue;
    protected int contactCallbackFlag = 1;
    protected int contactCallbackFilter;
    protected btCollisionShape collisionShape;
    public Object userData;

    protected btCollisionObject(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btCollisionObject(long cPtr, boolean cMemoryOwn) {
        this("btCollisionObject", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btCollisionObject obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btCollisionObject(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static btCollisionObject getInstance(long swigCPtr) {
        return swigCPtr == 0L ? null : instances.get(swigCPtr);
    }

    public static btCollisionObject getInstance(long swigCPtr, boolean owner) {
        if (swigCPtr == 0L) {
            return null;
        }
        btCollisionObject result = instances.get(swigCPtr);
        if (result == null) {
            result = new btCollisionObject(swigCPtr, owner);
        }
        return result;
    }

    public static void addInstance(btCollisionObject obj) {
        instances.put(btCollisionObject.getCPtr(obj), obj);
    }

    public static void removeInstance(btCollisionObject obj) {
        instances.remove(btCollisionObject.getCPtr(obj));
    }

    @Override
    protected void construct() {
        super.construct();
        this.gdxBridge = new GdxCollisionObjectBridge();
        this.internalSetGdxBridge(this.gdxBridge);
        btCollisionObject.addInstance(this);
    }

    @Override
    public void dispose() {
        if (this.swigCPtr != 0L) {
            btCollisionObject.removeInstance(this);
        }
        if (this.gdxBridge != null) {
            this.gdxBridge.dispose();
        }
        this.gdxBridge = null;
        if (this.collisionShape != null) {
            this.collisionShape.release();
        }
        this.collisionShape = null;
        super.dispose();
    }

    public int getUserValue() {
        return this.userValue;
    }

    public void setUserValue(int value) {
        this.userValue = value;
        this.gdxBridge.setUserValue(this.userValue);
    }

    public int getContactCallbackFlag() {
        return this.contactCallbackFlag;
    }

    public void setContactCallbackFlag(int flag) {
        this.contactCallbackFlag = flag;
        this.gdxBridge.setContactCallbackFlag(this.contactCallbackFlag);
    }

    public int getContactCallbackFilter() {
        return this.contactCallbackFilter;
    }

    public void setContactCallbackFilter(int filter) {
        this.contactCallbackFilter = filter;
        this.gdxBridge.setContactCallbackFilter(this.contactCallbackFilter);
    }

    public void setCollisionShape(btCollisionShape shape) {
        this.refCollisionShape(shape);
        this.internalSetCollisionShape(shape);
    }

    protected void refCollisionShape(btCollisionShape shape) {
        if (this.collisionShape == shape) {
            return;
        }
        if (this.collisionShape != null) {
            this.collisionShape.release();
        }
        this.collisionShape = shape;
        if (this.collisionShape != null) {
            this.collisionShape.obtain();
        }
    }

    public btCollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btCollisionObject_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        CollisionJNI.btCollisionObject_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btCollisionObject_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btCollisionObject_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btCollisionObject_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btCollisionObject_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btCollisionObject_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btCollisionObject_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public boolean mergesSimulationIslands() {
        return CollisionJNI.btCollisionObject_mergesSimulationIslands(this.swigCPtr, this);
    }

    public Vector3 getAnisotropicFriction() {
        return CollisionJNI.btCollisionObject_getAnisotropicFriction__SWIG_0(this.swigCPtr, this);
    }

    public void setAnisotropicFriction(Vector3 anisotropicFriction, int frictionMode) {
        CollisionJNI.btCollisionObject_setAnisotropicFriction__SWIG_0(this.swigCPtr, this, anisotropicFriction, frictionMode);
    }

    public void setAnisotropicFriction(Vector3 anisotropicFriction) {
        CollisionJNI.btCollisionObject_setAnisotropicFriction__SWIG_1(this.swigCPtr, this, anisotropicFriction);
    }

    public boolean hasAnisotropicFriction(int frictionMode) {
        return CollisionJNI.btCollisionObject_hasAnisotropicFriction__SWIG_0(this.swigCPtr, this, frictionMode);
    }

    public boolean hasAnisotropicFriction() {
        return CollisionJNI.btCollisionObject_hasAnisotropicFriction__SWIG_1(this.swigCPtr, this);
    }

    public void setContactProcessingThreshold(float contactProcessingThreshold) {
        CollisionJNI.btCollisionObject_setContactProcessingThreshold(this.swigCPtr, this, contactProcessingThreshold);
    }

    public float getContactProcessingThreshold() {
        return CollisionJNI.btCollisionObject_getContactProcessingThreshold(this.swigCPtr, this);
    }

    public boolean isStaticObject() {
        return CollisionJNI.btCollisionObject_isStaticObject(this.swigCPtr, this);
    }

    public boolean isKinematicObject() {
        return CollisionJNI.btCollisionObject_isKinematicObject(this.swigCPtr, this);
    }

    public boolean isStaticOrKinematicObject() {
        return CollisionJNI.btCollisionObject_isStaticOrKinematicObject(this.swigCPtr, this);
    }

    public boolean hasContactResponse() {
        return CollisionJNI.btCollisionObject_hasContactResponse(this.swigCPtr, this);
    }

    public btCollisionObject() {
        this(CollisionJNI.new_btCollisionObject(), true);
    }

    private void internalSetCollisionShape(btCollisionShape collisionShape) {
        CollisionJNI.btCollisionObject_internalSetCollisionShape(this.swigCPtr, this, btCollisionShape.getCPtr(collisionShape), collisionShape);
    }

    private btCollisionShape internalGetCollisionShape() {
        long cPtr = CollisionJNI.btCollisionObject_internalGetCollisionShape__SWIG_0(this.swigCPtr, this);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public void setIgnoreCollisionCheck(btCollisionObject co, boolean ignoreCollisionCheck) {
        CollisionJNI.btCollisionObject_setIgnoreCollisionCheck(this.swigCPtr, this, btCollisionObject.getCPtr(co), co, ignoreCollisionCheck);
    }

    public boolean checkCollideWithOverride(btCollisionObject co) {
        return CollisionJNI.btCollisionObject_checkCollideWithOverride(this.swigCPtr, this, btCollisionObject.getCPtr(co), co);
    }

    public long internalGetExtensionPointer() {
        return CollisionJNI.btCollisionObject_internalGetExtensionPointer(this.swigCPtr, this);
    }

    public void internalSetExtensionPointer(long pointer) {
        CollisionJNI.btCollisionObject_internalSetExtensionPointer(this.swigCPtr, this, pointer);
    }

    public int getActivationState() {
        return CollisionJNI.btCollisionObject_getActivationState(this.swigCPtr, this);
    }

    public void setActivationState(int newState) {
        CollisionJNI.btCollisionObject_setActivationState(this.swigCPtr, this, newState);
    }

    public void setDeactivationTime(float time) {
        CollisionJNI.btCollisionObject_setDeactivationTime(this.swigCPtr, this, time);
    }

    public float getDeactivationTime() {
        return CollisionJNI.btCollisionObject_getDeactivationTime(this.swigCPtr, this);
    }

    public void forceActivationState(int newState) {
        CollisionJNI.btCollisionObject_forceActivationState(this.swigCPtr, this, newState);
    }

    public void activate(boolean forceActivation) {
        CollisionJNI.btCollisionObject_activate__SWIG_0(this.swigCPtr, this, forceActivation);
    }

    public void activate() {
        CollisionJNI.btCollisionObject_activate__SWIG_1(this.swigCPtr, this);
    }

    public boolean isActive() {
        return CollisionJNI.btCollisionObject_isActive(this.swigCPtr, this);
    }

    public void setRestitution(float rest) {
        CollisionJNI.btCollisionObject_setRestitution(this.swigCPtr, this, rest);
    }

    public float getRestitution() {
        return CollisionJNI.btCollisionObject_getRestitution(this.swigCPtr, this);
    }

    public void setFriction(float frict) {
        CollisionJNI.btCollisionObject_setFriction(this.swigCPtr, this, frict);
    }

    public float getFriction() {
        return CollisionJNI.btCollisionObject_getFriction(this.swigCPtr, this);
    }

    public void setRollingFriction(float frict) {
        CollisionJNI.btCollisionObject_setRollingFriction(this.swigCPtr, this, frict);
    }

    public float getRollingFriction() {
        return CollisionJNI.btCollisionObject_getRollingFriction(this.swigCPtr, this);
    }

    public void setSpinningFriction(float frict) {
        CollisionJNI.btCollisionObject_setSpinningFriction(this.swigCPtr, this, frict);
    }

    public float getSpinningFriction() {
        return CollisionJNI.btCollisionObject_getSpinningFriction(this.swigCPtr, this);
    }

    public void setContactStiffnessAndDamping(float stiffness, float damping) {
        CollisionJNI.btCollisionObject_setContactStiffnessAndDamping(this.swigCPtr, this, stiffness, damping);
    }

    public float getContactStiffness() {
        return CollisionJNI.btCollisionObject_getContactStiffness(this.swigCPtr, this);
    }

    public float getContactDamping() {
        return CollisionJNI.btCollisionObject_getContactDamping(this.swigCPtr, this);
    }

    public int getInternalType() {
        return CollisionJNI.btCollisionObject_getInternalType(this.swigCPtr, this);
    }

    public Matrix4 getWorldTransform() {
        return CollisionJNI.btCollisionObject_getWorldTransform__SWIG_0(this.swigCPtr, this);
    }

    public void setWorldTransform(Matrix4 worldTrans) {
        CollisionJNI.btCollisionObject_setWorldTransform(this.swigCPtr, this, worldTrans);
    }

    public btBroadphaseProxy getBroadphaseHandle() {
        return btBroadphaseProxy.internalTemp(CollisionJNI.btCollisionObject_getBroadphaseHandle__SWIG_0(this.swigCPtr, this), false);
    }

    public void setBroadphaseHandle(btBroadphaseProxy handle) {
        CollisionJNI.btCollisionObject_setBroadphaseHandle(this.swigCPtr, this, btBroadphaseProxy.getCPtr(handle), handle);
    }

    public Matrix4 getInterpolationWorldTransform() {
        return CollisionJNI.btCollisionObject_getInterpolationWorldTransform__SWIG_0(this.swigCPtr, this);
    }

    public void setInterpolationWorldTransform(Matrix4 trans) {
        CollisionJNI.btCollisionObject_setInterpolationWorldTransform(this.swigCPtr, this, trans);
    }

    public void setInterpolationLinearVelocity(Vector3 linvel) {
        CollisionJNI.btCollisionObject_setInterpolationLinearVelocity(this.swigCPtr, this, linvel);
    }

    public void setInterpolationAngularVelocity(Vector3 angvel) {
        CollisionJNI.btCollisionObject_setInterpolationAngularVelocity(this.swigCPtr, this, angvel);
    }

    public Vector3 getInterpolationLinearVelocity() {
        return CollisionJNI.btCollisionObject_getInterpolationLinearVelocity__SWIG_0(this.swigCPtr, this);
    }

    public Vector3 getInterpolationAngularVelocity() {
        return CollisionJNI.btCollisionObject_getInterpolationAngularVelocity__SWIG_0(this.swigCPtr, this);
    }

    public int getIslandTag() {
        return CollisionJNI.btCollisionObject_getIslandTag(this.swigCPtr, this);
    }

    public void setIslandTag(int tag) {
        CollisionJNI.btCollisionObject_setIslandTag(this.swigCPtr, this, tag);
    }

    public int getCompanionId() {
        return CollisionJNI.btCollisionObject_getCompanionId(this.swigCPtr, this);
    }

    public void setCompanionId(int id) {
        CollisionJNI.btCollisionObject_setCompanionId(this.swigCPtr, this, id);
    }

    public int getWorldArrayIndex() {
        return CollisionJNI.btCollisionObject_getWorldArrayIndex(this.swigCPtr, this);
    }

    public void setWorldArrayIndex(int ix) {
        CollisionJNI.btCollisionObject_setWorldArrayIndex(this.swigCPtr, this, ix);
    }

    public float getHitFraction() {
        return CollisionJNI.btCollisionObject_getHitFraction(this.swigCPtr, this);
    }

    public void setHitFraction(float hitFraction) {
        CollisionJNI.btCollisionObject_setHitFraction(this.swigCPtr, this, hitFraction);
    }

    public int getCollisionFlags() {
        return CollisionJNI.btCollisionObject_getCollisionFlags(this.swigCPtr, this);
    }

    public void setCollisionFlags(int flags) {
        CollisionJNI.btCollisionObject_setCollisionFlags(this.swigCPtr, this, flags);
    }

    public float getCcdSweptSphereRadius() {
        return CollisionJNI.btCollisionObject_getCcdSweptSphereRadius(this.swigCPtr, this);
    }

    public void setCcdSweptSphereRadius(float radius) {
        CollisionJNI.btCollisionObject_setCcdSweptSphereRadius(this.swigCPtr, this, radius);
    }

    public float getCcdMotionThreshold() {
        return CollisionJNI.btCollisionObject_getCcdMotionThreshold(this.swigCPtr, this);
    }

    public float getCcdSquareMotionThreshold() {
        return CollisionJNI.btCollisionObject_getCcdSquareMotionThreshold(this.swigCPtr, this);
    }

    public void setCcdMotionThreshold(float ccdMotionThreshold) {
        CollisionJNI.btCollisionObject_setCcdMotionThreshold(this.swigCPtr, this, ccdMotionThreshold);
    }

    public long getUserPointer() {
        return CollisionJNI.btCollisionObject_getUserPointer(this.swigCPtr, this);
    }

    public int getUserIndex() {
        return CollisionJNI.btCollisionObject_getUserIndex(this.swigCPtr, this);
    }

    public int getUserIndex2() {
        return CollisionJNI.btCollisionObject_getUserIndex2(this.swigCPtr, this);
    }

    public void setUserPointer(long userPointer) {
        CollisionJNI.btCollisionObject_setUserPointer(this.swigCPtr, this, userPointer);
    }

    public void setUserIndex(int index) {
        CollisionJNI.btCollisionObject_setUserIndex(this.swigCPtr, this, index);
    }

    public void setUserIndex2(int index) {
        CollisionJNI.btCollisionObject_setUserIndex2(this.swigCPtr, this, index);
    }

    public int getUpdateRevisionInternal() {
        return CollisionJNI.btCollisionObject_getUpdateRevisionInternal(this.swigCPtr, this);
    }

    public void setCustomDebugColor(Vector3 colorRGB) {
        CollisionJNI.btCollisionObject_setCustomDebugColor(this.swigCPtr, this, colorRGB);
    }

    public void removeCustomDebugColor() {
        CollisionJNI.btCollisionObject_removeCustomDebugColor(this.swigCPtr, this);
    }

    public boolean getCustomDebugColor(Vector3 colorRGB) {
        return CollisionJNI.btCollisionObject_getCustomDebugColor(this.swigCPtr, this, colorRGB);
    }

    public boolean checkCollideWith(btCollisionObject co) {
        return CollisionJNI.btCollisionObject_checkCollideWith(this.swigCPtr, this, btCollisionObject.getCPtr(co), co);
    }

    public int calculateSerializeBufferSize() {
        return CollisionJNI.btCollisionObject_calculateSerializeBufferSize(this.swigCPtr, this);
    }

    public String serialize(long dataBuffer, btSerializer serializer) {
        return CollisionJNI.btCollisionObject_serialize(this.swigCPtr, this, dataBuffer, btSerializer.getCPtr(serializer), serializer);
    }

    public void serializeSingleObject(btSerializer serializer) {
        CollisionJNI.btCollisionObject_serializeSingleObject(this.swigCPtr, this, btSerializer.getCPtr(serializer), serializer);
    }

    private void internalSetGdxBridge(GdxCollisionObjectBridge bridge) {
        CollisionJNI.btCollisionObject_internalSetGdxBridge(this.swigCPtr, this, GdxCollisionObjectBridge.getCPtr(bridge), bridge);
    }

    private GdxCollisionObjectBridge internalGetGdxBridge() {
        long cPtr = CollisionJNI.btCollisionObject_internalGetGdxBridge(this.swigCPtr, this);
        return cPtr == 0L ? null : new GdxCollisionObjectBridge(cPtr, false);
    }

    public void getAnisotropicFriction(Vector3 out) {
        CollisionJNI.btCollisionObject_getAnisotropicFriction__SWIG_1(this.swigCPtr, this, out);
    }

    public void getWorldTransform(Matrix4 out) {
        CollisionJNI.btCollisionObject_getWorldTransform__SWIG_2(this.swigCPtr, this, out);
    }

    public void getInterpolationWorldTransform(Matrix4 out) {
        CollisionJNI.btCollisionObject_getInterpolationWorldTransform__SWIG_2(this.swigCPtr, this, out);
    }

    public void getInterpolationLinearVelocity(Vector3 out) {
        CollisionJNI.btCollisionObject_getInterpolationLinearVelocity__SWIG_1(this.swigCPtr, this, out);
    }

    public void getInterpolationAngularVelocity(Vector3 out) {
        CollisionJNI.btCollisionObject_getInterpolationAngularVelocity__SWIG_1(this.swigCPtr, this, out);
    }

    public static final class AnisotropicFrictionFlags {
        public static final int CF_ANISOTROPIC_FRICTION_DISABLED = 0;
        public static final int CF_ANISOTROPIC_FRICTION = 1;
        public static final int CF_ANISOTROPIC_ROLLING_FRICTION = 2;
    }

    public static final class CollisionObjectTypes {
        public static final int CO_COLLISION_OBJECT = 1;
        public static final int CO_RIGID_BODY = 2;
        public static final int CO_GHOST_OBJECT = 4;
        public static final int CO_SOFT_BODY = 8;
        public static final int CO_HF_FLUID = 16;
        public static final int CO_USER_TYPE = 32;
        public static final int CO_FEATHERSTONE_LINK = 64;
    }

    public static final class CollisionFlags {
        public static final int CF_STATIC_OBJECT = 1;
        public static final int CF_KINEMATIC_OBJECT = 2;
        public static final int CF_NO_CONTACT_RESPONSE = 4;
        public static final int CF_CUSTOM_MATERIAL_CALLBACK = 8;
        public static final int CF_CHARACTER_OBJECT = 16;
        public static final int CF_DISABLE_VISUALIZE_OBJECT = 32;
        public static final int CF_DISABLE_SPU_COLLISION_PROCESSING = 64;
        public static final int CF_HAS_CONTACT_STIFFNESS_DAMPING = 128;
        public static final int CF_HAS_CUSTOM_DEBUG_RENDERING_COLOR = 256;
        public static final int CF_HAS_FRICTION_ANCHOR = 512;
        public static final int CF_HAS_COLLISION_SOUND_TRIGGER = 1024;
    }
}

