/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.btBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btCollisionObject;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btCollisionWorld;
import com.badlogic.gdx.physics.bullet.collision.btCompoundShape;
import com.badlogic.gdx.physics.bullet.collision.btConvexHullShape;
import com.badlogic.gdx.physics.bullet.collision.btMultiSphereShape;
import com.badlogic.gdx.physics.bullet.collision.btOptimizedBvh;
import com.badlogic.gdx.physics.bullet.collision.btScaledBvhTriangleMeshShape;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterface;
import com.badlogic.gdx.physics.bullet.collision.btStridingMeshInterfaceData;
import com.badlogic.gdx.physics.bullet.collision.btTriangleIndexVertexArray;
import com.badlogic.gdx.physics.bullet.collision.btTriangleInfoMap;
import com.badlogic.gdx.physics.bullet.linearmath.btBulletSerializedArrays;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import java.nio.FloatBuffer;

public class btCollisionWorldImporter
extends BulletBase {
    private long swigCPtr;

    protected btCollisionWorldImporter(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btCollisionWorldImporter(long cPtr, boolean cMemoryOwn) {
        this("btCollisionWorldImporter", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btCollisionWorldImporter obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btCollisionWorldImporter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public btCollisionWorldImporter(btCollisionWorld world) {
        this(CollisionJNI.new_btCollisionWorldImporter(btCollisionWorld.getCPtr(world), world), true);
    }

    public boolean convertAllObjects(btBulletSerializedArrays arrays) {
        return CollisionJNI.btCollisionWorldImporter_convertAllObjects(this.swigCPtr, this, btBulletSerializedArrays.getCPtr(arrays), arrays);
    }

    public void deleteAllData() {
        CollisionJNI.btCollisionWorldImporter_deleteAllData(this.swigCPtr, this);
    }

    public void setVerboseMode(int verboseMode) {
        CollisionJNI.btCollisionWorldImporter_setVerboseMode(this.swigCPtr, this, verboseMode);
    }

    public int getVerboseMode() {
        return CollisionJNI.btCollisionWorldImporter_getVerboseMode(this.swigCPtr, this);
    }

    public int getNumCollisionShapes() {
        return CollisionJNI.btCollisionWorldImporter_getNumCollisionShapes(this.swigCPtr, this);
    }

    public btCollisionShape getCollisionShapeByIndex(int index) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_getCollisionShapeByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public int getNumRigidBodies() {
        return CollisionJNI.btCollisionWorldImporter_getNumRigidBodies(this.swigCPtr, this);
    }

    public btCollisionObject getRigidBodyByIndex(int index) {
        return btCollisionObject.getInstance(CollisionJNI.btCollisionWorldImporter_getRigidBodyByIndex(this.swigCPtr, this, index), false);
    }

    public int getNumBvhs() {
        return CollisionJNI.btCollisionWorldImporter_getNumBvhs(this.swigCPtr, this);
    }

    public btOptimizedBvh getBvhByIndex(int index) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_getBvhByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btOptimizedBvh(cPtr, false);
    }

    public int getNumTriangleInfoMaps() {
        return CollisionJNI.btCollisionWorldImporter_getNumTriangleInfoMaps(this.swigCPtr, this);
    }

    public btTriangleInfoMap getTriangleInfoMapByIndex(int index) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_getTriangleInfoMapByIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new btTriangleInfoMap(cPtr, false);
    }

    public btCollisionShape getCollisionShapeByName(String name) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_getCollisionShapeByName(this.swigCPtr, this, name);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionObject getCollisionObjectByName(String name) {
        return btCollisionObject.getInstance(CollisionJNI.btCollisionWorldImporter_getCollisionObjectByName(this.swigCPtr, this, name), false);
    }

    public String getNameForPointer(long ptr) {
        return CollisionJNI.btCollisionWorldImporter_getNameForPointer(this.swigCPtr, this, ptr);
    }

    public btCollisionObject createCollisionObject(Matrix4 startTransform, btCollisionShape shape, String bodyName) {
        return btCollisionObject.getInstance(CollisionJNI.btCollisionWorldImporter_createCollisionObject(this.swigCPtr, this, startTransform, btCollisionShape.getCPtr(shape), shape, bodyName), false);
    }

    public btCollisionShape createPlaneShape(Vector3 planeNormal, float planeConstant) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createPlaneShape(this.swigCPtr, this, planeNormal, planeConstant);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createBoxShape(Vector3 halfExtents) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createBoxShape(this.swigCPtr, this, halfExtents);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createSphereShape(float radius) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createSphereShape(this.swigCPtr, this, radius);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeX(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCapsuleShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeY(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCapsuleShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCapsuleShapeZ(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCapsuleShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeX(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCylinderShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeY(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCylinderShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createCylinderShapeZ(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCylinderShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeX(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createConeShapeX(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeY(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createConeShapeY(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape createConeShapeZ(float radius, float height) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createConeShapeZ(this.swigCPtr, this, radius, height);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btTriangleIndexVertexArray createTriangleMeshContainer() {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createTriangleMeshContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTriangleIndexVertexArray(cPtr, false);
    }

    public btBvhTriangleMeshShape createBvhTriangleMeshShape(btStridingMeshInterface trimesh, btOptimizedBvh bvh) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createBvhTriangleMeshShape(this.swigCPtr, this, btStridingMeshInterface.getCPtr(trimesh), trimesh, btOptimizedBvh.getCPtr(bvh), bvh);
        return cPtr == 0L ? null : new btBvhTriangleMeshShape(cPtr, false);
    }

    public btCollisionShape createConvexTriangleMeshShape(btStridingMeshInterface trimesh) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createConvexTriangleMeshShape(this.swigCPtr, this, btStridingMeshInterface.getCPtr(trimesh), trimesh);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btStridingMeshInterfaceData createStridingMeshInterfaceData(btStridingMeshInterfaceData interfaceData) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createStridingMeshInterfaceData(this.swigCPtr, this, btStridingMeshInterfaceData.getCPtr(interfaceData), interfaceData);
        return cPtr == 0L ? null : new btStridingMeshInterfaceData(cPtr, false);
    }

    public btConvexHullShape createConvexHullShape() {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createConvexHullShape(this.swigCPtr, this);
        return cPtr == 0L ? null : new btConvexHullShape(cPtr, false);
    }

    public btCompoundShape createCompoundShape() {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createCompoundShape(this.swigCPtr, this);
        return cPtr == 0L ? null : new btCompoundShape(cPtr, false);
    }

    public btScaledBvhTriangleMeshShape createScaledTrangleMeshShape(btBvhTriangleMeshShape meshShape, Vector3 localScalingbtBvhTriangleMeshShape) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createScaledTrangleMeshShape(this.swigCPtr, this, btBvhTriangleMeshShape.getCPtr(meshShape), meshShape, localScalingbtBvhTriangleMeshShape);
        return cPtr == 0L ? null : new btScaledBvhTriangleMeshShape(cPtr, false);
    }

    public btMultiSphereShape createMultiSphereShape(btVector3 positions, FloatBuffer radi, int numSpheres) {
        assert (radi.isDirect()) : "Buffer must be allocated direct.";
        long cPtr = CollisionJNI.btCollisionWorldImporter_createMultiSphereShape(this.swigCPtr, this, btVector3.getCPtr(positions), positions, radi, numSpheres);
        return cPtr == 0L ? null : new btMultiSphereShape(cPtr, false);
    }

    public btTriangleIndexVertexArray createMeshInterface(btStridingMeshInterfaceData meshData) {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createMeshInterface(this.swigCPtr, this, btStridingMeshInterfaceData.getCPtr(meshData), meshData);
        return cPtr == 0L ? null : new btTriangleIndexVertexArray(cPtr, false);
    }

    public btOptimizedBvh createOptimizedBvh() {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createOptimizedBvh(this.swigCPtr, this);
        return cPtr == 0L ? null : new btOptimizedBvh(cPtr, false);
    }

    public btTriangleInfoMap createTriangleInfoMap() {
        long cPtr = CollisionJNI.btCollisionWorldImporter_createTriangleInfoMap(this.swigCPtr, this);
        return cPtr == 0L ? null : new btTriangleInfoMap(cPtr, false);
    }
}

