/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_btAlignedObjectArrayT_btBvhSubtreeInfo_t;
import com.badlogic.gdx.physics.bullet.collision.SWIGTYPE_p_btAlignedObjectArrayT_btQuantizedBvhNode_t;
import com.badlogic.gdx.physics.bullet.collision.btNodeOverlapCallback;
import com.badlogic.gdx.physics.bullet.collision.btQuantizedBvhDoubleData;
import com.badlogic.gdx.physics.bullet.collision.btQuantizedBvhFloatData;
import com.badlogic.gdx.physics.bullet.linearmath.btSerializer;
import java.nio.IntBuffer;

public class btQuantizedBvh
extends BulletBase {
    private long swigCPtr;

    protected btQuantizedBvh(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btQuantizedBvh(long cPtr, boolean cMemoryOwn) {
        this("btQuantizedBvh", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btQuantizedBvh obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btQuantizedBvh(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long operatorNew(long sizeInBytes) {
        return CollisionJNI.btQuantizedBvh_operatorNew__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDelete(long ptr) {
        CollisionJNI.btQuantizedBvh_operatorDelete__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNew(long arg0, long ptr) {
        return CollisionJNI.btQuantizedBvh_operatorNew__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDelete(long arg0, long arg1) {
        CollisionJNI.btQuantizedBvh_operatorDelete__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public long operatorNewArray(long sizeInBytes) {
        return CollisionJNI.btQuantizedBvh_operatorNewArray__SWIG_0(this.swigCPtr, this, sizeInBytes);
    }

    public void operatorDeleteArray(long ptr) {
        CollisionJNI.btQuantizedBvh_operatorDeleteArray__SWIG_0(this.swigCPtr, this, ptr);
    }

    public long operatorNewArray(long arg0, long ptr) {
        return CollisionJNI.btQuantizedBvh_operatorNewArray__SWIG_1(this.swigCPtr, this, arg0, ptr);
    }

    public void operatorDeleteArray(long arg0, long arg1) {
        CollisionJNI.btQuantizedBvh_operatorDeleteArray__SWIG_1(this.swigCPtr, this, arg0, arg1);
    }

    public btQuantizedBvh() {
        this(CollisionJNI.new_btQuantizedBvh(), true);
    }

    public void setQuantizationValues(Vector3 bvhAabbMin, Vector3 bvhAabbMax, float quantizationMargin) {
        CollisionJNI.btQuantizedBvh_setQuantizationValues__SWIG_0(this.swigCPtr, this, bvhAabbMin, bvhAabbMax, quantizationMargin);
    }

    public void setQuantizationValues(Vector3 bvhAabbMin, Vector3 bvhAabbMax) {
        CollisionJNI.btQuantizedBvh_setQuantizationValues__SWIG_1(this.swigCPtr, this, bvhAabbMin, bvhAabbMax);
    }

    public SWIGTYPE_p_btAlignedObjectArrayT_btQuantizedBvhNode_t getLeafNodeArray() {
        return new SWIGTYPE_p_btAlignedObjectArrayT_btQuantizedBvhNode_t(CollisionJNI.btQuantizedBvh_getLeafNodeArray(this.swigCPtr, this), false);
    }

    public void buildInternal() {
        CollisionJNI.btQuantizedBvh_buildInternal(this.swigCPtr, this);
    }

    public void reportAabbOverlappingNodex(btNodeOverlapCallback nodeCallback, Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btQuantizedBvh_reportAabbOverlappingNodex(this.swigCPtr, this, btNodeOverlapCallback.getCPtr(nodeCallback), nodeCallback, aabbMin, aabbMax);
    }

    public void reportRayOverlappingNodex(btNodeOverlapCallback nodeCallback, Vector3 raySource, Vector3 rayTarget) {
        CollisionJNI.btQuantizedBvh_reportRayOverlappingNodex(this.swigCPtr, this, btNodeOverlapCallback.getCPtr(nodeCallback), nodeCallback, raySource, rayTarget);
    }

    public void reportBoxCastOverlappingNodex(btNodeOverlapCallback nodeCallback, Vector3 raySource, Vector3 rayTarget, Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btQuantizedBvh_reportBoxCastOverlappingNodex(this.swigCPtr, this, btNodeOverlapCallback.getCPtr(nodeCallback), nodeCallback, raySource, rayTarget, aabbMin, aabbMax);
    }

    public void quantize(IntBuffer out, Vector3 point, int isMax) {
        assert (out.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btQuantizedBvh_quantize(this.swigCPtr, this, out, point, isMax);
    }

    public void quantizeWithClamp(IntBuffer out, Vector3 point2, int isMax) {
        assert (out.isDirect()) : "Buffer must be allocated direct.";
        CollisionJNI.btQuantizedBvh_quantizeWithClamp(this.swigCPtr, this, out, point2, isMax);
    }

    public Vector3 unQuantize(IntBuffer vecIn) {
        assert (vecIn.isDirect()) : "Buffer must be allocated direct.";
        return CollisionJNI.btQuantizedBvh_unQuantize(this.swigCPtr, this, vecIn);
    }

    public void setTraversalMode(int traversalMode) {
        CollisionJNI.btQuantizedBvh_setTraversalMode(this.swigCPtr, this, traversalMode);
    }

    public SWIGTYPE_p_btAlignedObjectArrayT_btQuantizedBvhNode_t getQuantizedNodeArray() {
        return new SWIGTYPE_p_btAlignedObjectArrayT_btQuantizedBvhNode_t(CollisionJNI.btQuantizedBvh_getQuantizedNodeArray(this.swigCPtr, this), false);
    }

    public SWIGTYPE_p_btAlignedObjectArrayT_btBvhSubtreeInfo_t getSubtreeInfoArray() {
        return new SWIGTYPE_p_btAlignedObjectArrayT_btBvhSubtreeInfo_t(CollisionJNI.btQuantizedBvh_getSubtreeInfoArray(this.swigCPtr, this), false);
    }

    public long calculateSerializeBufferSize() {
        return CollisionJNI.btQuantizedBvh_calculateSerializeBufferSize(this.swigCPtr, this);
    }

    public boolean serialize(long o_alignedDataBuffer, long i_dataBufferSize, boolean i_swapEndian) {
        return CollisionJNI.btQuantizedBvh_serialize__SWIG_0(this.swigCPtr, this, o_alignedDataBuffer, i_dataBufferSize, i_swapEndian);
    }

    public static btQuantizedBvh deSerializeInPlace(long i_alignedDataBuffer, long i_dataBufferSize, boolean i_swapEndian) {
        long cPtr = CollisionJNI.btQuantizedBvh_deSerializeInPlace(i_alignedDataBuffer, i_dataBufferSize, i_swapEndian);
        return cPtr == 0L ? null : new btQuantizedBvh(cPtr, false);
    }

    public static long getAlignmentSerializationPadding() {
        return CollisionJNI.btQuantizedBvh_getAlignmentSerializationPadding();
    }

    public int calculateSerializeBufferSizeNew() {
        return CollisionJNI.btQuantizedBvh_calculateSerializeBufferSizeNew(this.swigCPtr, this);
    }

    public String serialize(long dataBuffer, btSerializer serializer) {
        return CollisionJNI.btQuantizedBvh_serialize__SWIG_1(this.swigCPtr, this, dataBuffer, btSerializer.getCPtr(serializer), serializer);
    }

    public void deSerializeFloat(btQuantizedBvhFloatData quantizedBvhFloatData) {
        CollisionJNI.btQuantizedBvh_deSerializeFloat(this.swigCPtr, this, btQuantizedBvhFloatData.getCPtr(quantizedBvhFloatData), quantizedBvhFloatData);
    }

    public void deSerializeDouble(btQuantizedBvhDoubleData quantizedBvhDoubleData) {
        CollisionJNI.btQuantizedBvh_deSerializeDouble(this.swigCPtr, this, btQuantizedBvhDoubleData.getCPtr(quantizedBvhDoubleData), quantizedBvhDoubleData);
    }

    public boolean isQuantized() {
        return CollisionJNI.btQuantizedBvh_isQuantized(this.swigCPtr, this);
    }

    public static final class btTraversalMode {
        public static final int TRAVERSAL_STACKLESS = 0;
        public static final int TRAVERSAL_STACKLESS_CACHE_FRIENDLY = 1;
        public static final int TRAVERSAL_RECURSIVE = 2;
    }
}

