/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import io.github.some_example_name.GameScreen;
import io.github.some_example_name.Player;

public class Dean {
    private Vector2 position;
    private Vector2 startPosition;
    private Vector2 velocity;
    private Texture texture;
    private Player player;
    private GameScreen gameScreen;
    private float speed = 0.7f;

    public Dean(float x, float y, Player player, GameScreen gameScreen) {
        this.position = new Vector2(x, y);
        this.startPosition = new Vector2(x, y);
        this.texture = new Texture("Dean-front.png");
        this.player = player;
        this.gameScreen = gameScreen;
        this.velocity = new Vector2();
    }

    public void update(float delta) {
        Vector2 direction = new Vector2(this.player.getPosition()).sub(this.position);
        direction.nor();
        float newX = this.position.x + direction.x * this.speed;
        float newY = this.position.y + direction.y * this.speed;
        if (!this.gameScreen.isCellBlocked(newX, newY)) {
            this.position.set(newX, newY);
        }
        this.tryMoveDiagonally(delta, direction);
    }

    private void tryMoveDiagonally(float delta, Vector2 direction) {
        float newX = this.position.x + direction.x * this.speed;
        if (!this.gameScreen.isCellBlocked(newX, this.position.y)) {
            this.position.x = newX;
            return;
        }
        float newY = this.position.y + direction.y * this.speed;
        if (!this.gameScreen.isCellBlocked(this.position.x, newY)) {
            this.position.y = newY;
            return;
        }
    }

    public void resetToStart(int caughtNumber) {
        if (caughtNumber % 2 == 0) {
            this.position.set(this.startPosition);
        } else {
            this.position.set(390.0f, 400.0f);
        }
    }

    public void render(SpriteBatch batch) {
        batch.draw(this.texture, this.position.x, this.position.y, 16.0f, 16.0f);
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.position.x, this.position.y, 16.0f, 16.0f);
    }

    public void dispose() {
        this.texture.dispose();
    }
}

