/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.FitViewport;
import io.github.some_example_name.BusTicket;
import io.github.some_example_name.Dean;
import io.github.some_example_name.GameOverScreen;
import io.github.some_example_name.GameTimer;
import io.github.some_example_name.Locker;
import io.github.some_example_name.MenuScreen;
import io.github.some_example_name.MyGame;
import io.github.some_example_name.NPC;
import io.github.some_example_name.Player;
import io.github.some_example_name.WinScreen;

public class GameScreen
implements Screen {
    private final MyGame game;
    private boolean isPaused = false;
    TiledMap tiledMap;
    OrthogonalTiledMapRenderer mapRenderer;
    OrthographicCamera camera;
    FitViewport viewport;
    private SpriteBatch batch;
    private Player player;
    private final Stage uiStage;
    private final Table uiTable;
    private final Skin uiSkin;
    private final GameTimer gameTimer;
    private BusTicket busTicket;
    private Locker locker;
    private BitmapFont font;
    private boolean canPickUpTicket = false;
    private Rectangle busInteractionArea;
    private boolean canEndGame = false;
    private final int MAP_WIDTH = 640;
    private final int MAP_HEIGHT = 640;
    private Dean dean;
    private NPC friend;
    private int timesCaughtByDean = 0;
    private BitmapFont catchCounterFont;

    public GameScreen(MyGame game) {
        MapObject busObject;
        this.game = game;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 640.0f, 640.0f);
        this.camera.zoom = 0.5f;
        this.camera.update();
        this.tiledMap = new TmxMapLoader().load("Tile Maps/Final Game Map - Maze.tmx");
        this.mapRenderer = new OrthogonalTiledMapRenderer(this.tiledMap);
        this.viewport = new FitViewport(640.0f, 640.0f, this.camera);
        this.batch = new SpriteBatch();
        this.player = new Player(145.0f, 70.0f);
        this.locker = new Locker(495.0f, 575.0f);
        this.dean = new Dean(90.0f, 450.0f, this.player, this);
        this.friend = new NPC(560.0f, 300.0f);
        this.catchCounterFont = new BitmapFont();
        this.catchCounterFont.getData().setScale(1.5f);
        this.font = new BitmapFont();
        MapObjects eventObjects = this.tiledMap.getLayers().get("Events").getObjects();
        MapObject ticketObject = eventObjects.get("BusTicket");
        if (ticketObject != null && ticketObject instanceof RectangleMapObject) {
            RectangleMapObject rect = (RectangleMapObject)ticketObject;
            this.busTicket = new BusTicket(rect.getRectangle().x, rect.getRectangle().y);
        }
        if ((busObject = eventObjects.get("Bus")) != null && busObject instanceof RectangleMapObject) {
            this.busInteractionArea = ((RectangleMapObject)busObject).getRectangle();
        }
        this.uiSkin = new Skin(Gdx.files.internal("ui/uiskin.json"));
        this.uiStage = new Stage(new FitViewport(640.0f, 640.0f));
        this.uiTable = new Table();
        this.uiTable.setFillParent(true);
        this.uiStage.addActor(this.uiTable);
        this.gameTimer = new GameTimer(this.uiSkin, this.uiTable);
        this.uiTable.top().right().pad(10.0f, 0.0f, 0.0f, 10.0f);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.handleInput();
        if (this.isPaused) {
            this.camera.update();
            this.mapRenderer.setView(this.camera);
            this.mapRenderer.render();
            this.batch.setProjectionMatrix(this.camera.combined);
            this.batch.begin();
            this.font.draw((Batch)this.batch, "Game Paused", this.camera.position.x - 50.0f, this.camera.position.y + 50.0f);
            this.player.render(this.batch);
            if (this.busTicket != null && this.busTicket.isCollected()) {
                this.busTicket.renderAsIcon(this.batch, this.camera);
            }
            this.batch.end();
            this.uiStage.act(delta);
            this.uiStage.draw();
            return;
        }
        this.friend.update(this.player);
        this.dean.update(delta);
        if (this.player.getPosition().dst(this.dean.getPosition()) < 16.0f) {
            this.player.getPosition().set(145.0f, 70.0f);
            ++this.timesCaughtByDean;
            this.dean.resetToStart(this.timesCaughtByDean);
        }
        this.locker.update(this.player, delta);
        if (this.busTicket != null) {
            if (!this.busTicket.isCollected()) {
                if (this.player.getPosition().dst(this.busTicket.getPosition()) < 16.0f) {
                    this.busTicket.discover();
                    this.canPickUpTicket = true;
                } else {
                    this.canPickUpTicket = false;
                }
            } else {
                Rectangle playerRect = new Rectangle(this.player.getPosition().x, this.player.getPosition().y, 16.0f, 16.0f);
                this.canEndGame = this.busInteractionArea != null && playerRect.overlaps(this.busInteractionArea);
            }
        }
        this.camera.position.set(this.player.getPosition().x, this.player.getPosition().y, 0.0f);
        this.camera.update();
        this.mapRenderer.setView(this.camera);
        this.mapRenderer.render();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.batch.setProjectionMatrix(this.uiStage.getCamera().combined);
        this.font.draw((Batch)this.batch, "Positive Event Encountered = " + (this.locker.isBoostActive() ? "1" : "0") + "/1", 35.0f, 630.0f);
        this.font.draw((Batch)this.batch, "Negative Event Encountered = " + (this.timesCaughtByDean > 0 ? "1" : "0") + "/1", 35.0f, 610.0f);
        this.font.draw((Batch)this.batch, "Hidden Event Encountered = " + (this.busTicket.isCollected() ? "1" : "0") + "/1", 35.0f, 590.0f);
        this.batch.setProjectionMatrix(this.camera.combined);
        if (this.busTicket != null) {
            this.busTicket.render(this.batch);
        }
        if (this.canPickUpTicket) {
            this.font.draw((Batch)this.batch, "Press E to pick up", this.player.getPosition().x - 50.0f, this.player.getPosition().y + 30.0f);
        }
        if (this.canEndGame) {
            this.font.draw((Batch)this.batch, "Press E to use ticket", this.player.getPosition().x - 50.0f, this.player.getPosition().y + 30.0f);
        }
        this.locker.render(this.batch);
        this.dean.render(this.batch);
        this.friend.render(this.batch);
        this.player.render(this.batch);
        if (this.busTicket != null && this.busTicket.isCollected()) {
            this.busTicket.renderAsIcon(this.batch, this.camera);
        }
        this.batch.end();
        if (!this.isPaused) {
            this.gameTimer.decrementTimer(delta);
        }
        if (this.gameTimer.getTimeLeft() == 0.0f) {
            this.gameTimer.onTimeUp();
            this.game.setScreen(new MenuScreen(this.game));
        }
        if (Gdx.input.isKeyJustPressed(111)) {
            this.game.setScreen(new MenuScreen(this.game));
        }
        if (this.gameTimer.getTimeLeft() == 0.0f) {
            this.gameTimer.onTimeUp();
            this.game.setScreen(new GameOverScreen(this.game));
        }
        this.uiStage.act(delta);
        this.uiStage.draw();
    }

    private void handleInput() {
        float moveSpeed = 1.0f;
        if (this.locker != null && this.locker.isBoostActive()) {
            moveSpeed = 2.0f;
        }
        float newX = this.player.getPosition().x;
        float newY = this.player.getPosition().y;
        if (Gdx.input.isKeyPressed(51)) {
            newY += moveSpeed;
            this.player.setDirection(Player.Direction.UP);
        } else if (Gdx.input.isKeyPressed(47)) {
            newY -= moveSpeed;
            this.player.setDirection(Player.Direction.DOWN);
        } else if (Gdx.input.isKeyPressed(29)) {
            newX -= moveSpeed;
            this.player.setDirection(Player.Direction.LEFT);
        } else if (Gdx.input.isKeyPressed(32)) {
            newX += moveSpeed;
            this.player.setDirection(Player.Direction.RIGHT);
        } else if (this.canPickUpTicket && Gdx.input.isKeyJustPressed(33)) {
            this.busTicket.collect();
            this.canPickUpTicket = false;
        }
        if (Gdx.input.isKeyJustPressed(44)) {
            this.isPaused = !this.isPaused;
            return;
        }
        if (this.isPaused) {
            return;
        }
        if (this.canEndGame && Gdx.input.isKeyJustPressed(33)) {
            int finalScore = this.calculateFinalScore();
            int timeRemaining = (int)this.gameTimer.getTimeLeft();
            int timesCaught = this.getTimesCaughtByDean();
            this.game.setScreen(new WinScreen(this.game, finalScore, timeRemaining, timesCaught));
        }
        if (!this.isCellBlocked(newX, newY)) {
            this.player.getPosition().set(newX, newY);
        }
    }

    public boolean isCellBlocked(float x, float y) {
        for (int i = 0; i < this.tiledMap.getLayers().getCount(); ++i) {
            int tileY;
            int tileX;
            TiledMapTileLayer layer;
            TiledMapTileLayer.Cell cell;
            if (!(this.tiledMap.getLayers().get(i) instanceof TiledMapTileLayer) || (cell = (layer = (TiledMapTileLayer)this.tiledMap.getLayers().get(i)).getCell(tileX = (int)((x + 8.0f) / (float)layer.getTileWidth()), tileY = (int)((y + 8.0f) / (float)layer.getTileHeight()))) == null || cell.getTile() == null || !cell.getTile().getProperties().containsKey("collidable") && !layer.getProperties().containsKey("collidable")) continue;
            return true;
        }
        return false;
    }

    public int calculateFinalScore() {
        int timeRemainingSeconds = (int)this.gameTimer.getTimeLeft();
        int minutes = timeRemainingSeconds / 60;
        int seconds = timeRemainingSeconds % 60;
        int timeScore = minutes * 100 + seconds;
        int deanPenalty = this.timesCaughtByDean * 5;
        int finalScore = timeScore - deanPenalty;
        return Math.max(0, finalScore);
    }

    @Override
    public void resize(int width, int height) {
        this.uiStage.getViewport().update(width, height, true);
        this.uiStage.getViewport().apply();
        this.viewport.update(width, height);
        this.viewport.apply();
    }

    public int getTimesCaughtByDean() {
        return this.timesCaughtByDean;
    }

    @Override
    public void dispose() {
        this.tiledMap.dispose();
        this.mapRenderer.dispose();
        this.batch.dispose();
        this.player.dispose();
        this.locker.dispose();
        this.font.dispose();
        this.uiStage.dispose();
        this.dean.dispose();
        this.catchCounterFont.dispose();
        this.friend.dispose();
        if (this.busTicket != null) {
            this.busTicket.dispose();
        }
    }

    @Override
    public void show() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }
}

