/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;

public class GameTimer {
    private Float timeLeft;
    private Label timerLabel;
    private Sound timerDingSFX;

    public GameTimer(Skin skin, Table table) {
        this.timeLeft = Float.valueOf(300.0f);
        this.timerDingSFX = Gdx.audio.newSound(Gdx.files.internal("ding.wav"));
        this.instantiateLabel(skin, table);
    }

    public GameTimer(Skin skin, Table table, float seconds) {
        this.timeLeft = Float.valueOf(seconds);
        this.timerDingSFX = Gdx.audio.newSound(Gdx.files.internal("ding.wav"));
        this.instantiateLabel(skin, table);
    }

    public String toString() {
        long minutes = (long)Math.floor(this.timeLeft.floatValue() / 60.0f);
        long seconds = (long)Math.floor(this.timeLeft.floatValue()) - minutes * 60L;
        return String.format("%02d : %02d", minutes, seconds);
    }

    public void decrementTimer(float decrementaion) {
        this.timeLeft = Float.valueOf(Math.max(0.0f, this.timeLeft.floatValue() - decrementaion));
        this.timerLabel.setText(this.toString());
    }

    public void onTimeUp() {
        this.timerDingSFX.play(3.0f);
    }

    public float getTimeLeft() {
        return this.timeLeft.floatValue();
    }

    public Label getTimerLabel() {
        return this.timerLabel;
    }

    private void instantiateLabel(Skin skin, Table table) {
        this.timerLabel = new Label((CharSequence)"", skin);
        table.add(this.timerLabel).row();
    }
}

