/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import io.github.some_example_name.Player;

public class Locker {
    private Texture texture = new Texture("locker.png");
    private Vector2 position;
    private Rectangle bounds;
    private boolean searched = false;
    private boolean showMessage = false;
    private float messageTimer = 0.0f;
    private final float messageDuration = 5.0f;
    private final float speedBoostAmount = 200.0f;
    private final float speedBoostDuration = 10.0f;
    private float speedBoostTimer = 0.0f;
    private BitmapFont font;

    public Locker(float x, float y) {
        this.position = new Vector2(x, y);
        this.bounds = new Rectangle(x, y, this.texture.getWidth(), this.texture.getHeight());
        this.font = new BitmapFont();
    }

    public void update(Player player, float delta) {
        if (!this.searched && Gdx.input.isKeyJustPressed(33) && player.getPosition().dst(this.position) < 50.0f) {
            this.searched = true;
            this.showMessage = true;
            this.messageTimer = 0.0f;
            this.speedBoostTimer = 10.0f;
        }
        if (this.speedBoostTimer > 0.0f) {
            this.speedBoostTimer -= delta;
        }
        if (this.showMessage) {
            this.messageTimer += delta;
            if (this.messageTimer > 5.0f) {
                this.showMessage = false;
            }
        }
    }

    public void render(SpriteBatch batch) {
        batch.draw(this.texture, this.position.x, this.position.y);
        if (this.showMessage) {
            this.font.draw((Batch)batch, "You found a sweet treat,\n enjoy the sugar induced speed boost!", this.position.x - 100.0f, this.position.y + (float)this.texture.getHeight() + 40.0f);
        }
    }

    public void dispose() {
        this.texture.dispose();
        this.font.dispose();
    }

    public boolean isBoostActive() {
        return this.speedBoostTimer > 0.0f;
    }
}

