/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.viewport.FitViewport;
import io.github.some_example_name.MyGame;
import io.github.some_example_name.TutorialScreen;

public class MenuScreen
implements Screen {
    private final MyGame game;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private BitmapFont font;
    private FitViewport viewport;
    private final int MENU_WIDTH = 640;
    private final int MENU_HEIGHT = 480;

    public MenuScreen(MyGame game) {
        this.game = game;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 640.0f, 480.0f);
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
        this.font.getData().setScale(2.0f);
        this.viewport = new FitViewport(640.0f, 480.0f, this.camera);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.font.draw((Batch)this.batch, "Escape from University", 170.0f, 350.0f);
        this.font.draw((Batch)this.batch, "Press SPACE to Start", 175.0f, 250.0f);
        this.font.draw((Batch)this.batch, "Press ESC to Exit", 198.0f, 200.0f);
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(62)) {
            this.game.setScreen(new TutorialScreen(this.game));
        } else if (Gdx.input.isKeyJustPressed(111)) {
            Gdx.app.exit();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.font.dispose();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }
}

