/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import io.github.some_example_name.Player;

public class NPC {
    private Texture texture = new Texture("NPC.png");
    private Vector2 position;
    private Rectangle bounds;
    private BitmapFont font;
    private boolean showMessage = false;

    public NPC(float x, float y) {
        this.position = new Vector2(x, y);
        this.bounds = new Rectangle(x, y, this.texture.getWidth(), this.texture.getHeight());
        this.font = new BitmapFont();
    }

    public void update(Player player) {
        if (player.getPosition().dst(this.position) < 50.0f && Gdx.input.isKeyJustPressed(33)) {
            this.showMessage = true;
        }
        if (this.showMessage && player.getPosition().dst(this.position) > 60.0f) {
            this.showMessage = false;
        }
    }

    public void render(SpriteBatch batch) {
        batch.draw(this.texture, this.position.x, this.position.y);
        if (this.showMessage) {
            this.font.draw((Batch)batch, "Hey friend!\nDon't forget your bus ticket...\nyou always drop them by your room", this.position.x - 100.0f, this.position.y + (float)this.texture.getHeight() + 40.0f);
        }
    }

    public void dispose() {
        this.texture.dispose();
        this.font.dispose();
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }
}

