/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;

public class Player {
    private Vector2 position;
    private Texture frontTexture;
    private Texture backTexture;
    private Texture sideTexture;
    private TextureRegion frontFrame;
    private TextureRegion backFrame;
    private TextureRegion sideFrame;
    private TextureRegion currentFrame;

    public Player(float x, float y) {
        this.position = new Vector2(x, y);
        this.frontTexture = new Texture("Player-front.png");
        this.backTexture = new Texture("Player-back.png");
        this.sideTexture = new Texture("Player-side.png");
        this.frontFrame = new TextureRegion(this.frontTexture);
        this.backFrame = new TextureRegion(this.backTexture);
        this.sideFrame = new TextureRegion(this.sideTexture);
        this.currentFrame = this.frontFrame;
    }

    public void setDirection(Direction newDirection) {
        switch (newDirection) {
            case UP: {
                this.currentFrame = this.backFrame;
                break;
            }
            case DOWN: {
                this.currentFrame = this.frontFrame;
                break;
            }
            case LEFT: {
                this.currentFrame = this.sideFrame;
                if (!this.currentFrame.isFlipX()) break;
                this.currentFrame.flip(true, false);
                break;
            }
            case RIGHT: {
                this.currentFrame = this.sideFrame;
                if (this.currentFrame.isFlipX()) break;
                this.currentFrame.flip(true, false);
            }
        }
    }

    public void render(SpriteBatch batch) {
        batch.draw(this.currentFrame, this.position.x, this.position.y);
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public void dispose() {
        this.frontTexture.dispose();
        this.backTexture.dispose();
        this.sideTexture.dispose();
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

