/*
 * Decompiled with CFR 0.152.
 */
package io.github.some_example_name;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import io.github.some_example_name.MenuScreen;
import io.github.some_example_name.MyGame;

public class WinScreen
implements Screen {
    private final MyGame game;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private BitmapFont font;
    private int finalScore;
    private int timeRemaining;
    private int timesCaught;

    public WinScreen(MyGame game, int finalScore, int timeRemaining, int timesCaught) {
        this.game = game;
        this.finalScore = finalScore;
        this.timeRemaining = timeRemaining;
        this.timesCaught = timesCaught;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 640.0f, 480.0f);
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
        this.font.getData().setScale(2.5f);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.1f, 0.3f, 0.1f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.font.draw((Batch)this.batch, "You Win!", 250.0f, 350.0f);
        this.font.draw((Batch)this.batch, "Final Score = " + this.finalScore, 188.0f, 310.0f);
        this.font.draw((Batch)this.batch, "Dean Penalty = " + this.timesCaught * 5, 188.0f, 270.0f);
        this.font.draw((Batch)this.batch, "Press SPACE to return to menu", 100.0f, 150.0f);
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(62)) {
            this.game.setScreen(new MenuScreen(this.game));
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.font.dispose();
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }
}

